/*
 * Decompiled with CFR 0.152.
 */
package emt.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.item.ItemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import thaumcraft.api.IRunicArmor;
import thaumcraft.api.IWarpingGear;

public class ItemOneRing
extends ItemBase
implements IBauble,
IWarpingGear,
IRunicArmor {
    private static final String NBT_TAG_FORGE_DATA = "EMT";
    private static final String NBT_TAG_MIND_CORRUPTION = "MindCorruption";
    private static final String NBT_TAG_WARP = "warp";
    public IIcon[] icon = new IIcon[16];
    public Random random = new Random();

    public ItemOneRing() {
        super("bauble");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public int getWarp(ItemStack itemstack, EntityPlayer player) {
        return this.getItemWarpLevel(itemstack, false);
    }

    public String func_77667_c(ItemStack itemstack) {
        String name = "";
        switch (itemstack.func_77960_j()) {
            case 0: {
                name = "oneRing";
                break;
            }
            default: {
                name = "nothing";
            }
        }
        return "item.EMT.bauble." + name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ri) {
        this.icon[0] = ri.func_94245_a("emt:onering");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icon[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Item)this, 1, 0));
    }

    public BaubleType getBaubleType(ItemStack stack) {
        if (stack.func_77960_j() <= 0) {
            return BaubleType.RING;
        }
        return null;
    }

    private NBTTagCompound getOrSetForgeTag(EntityPlayer pPlayer) {
        NBTTagCompound tPlayerNBT = pPlayer.getEntityData();
        NBTTagCompound forgeTag = new NBTTagCompound();
        if (tPlayerNBT.func_74764_b(NBT_TAG_FORGE_DATA)) {
            forgeTag = tPlayerNBT.func_74775_l(NBT_TAG_FORGE_DATA);
        } else {
            tPlayerNBT.func_74782_a(NBT_TAG_FORGE_DATA, (NBTBase)forgeTag);
        }
        return forgeTag;
    }

    private int getItemWarpLevel(ItemStack stack, boolean increment) {
        NBTTagCompound tWarpTag = new NBTTagCompound();
        int tWarpLevel = 0;
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b(NBT_TAG_WARP)) {
                tWarpLevel = stack.func_77978_p().func_74762_e(NBT_TAG_WARP);
                if (increment) {
                    stack.func_77978_p().func_74768_a(NBT_TAG_WARP, ++tWarpLevel);
                }
            }
        } else {
            tWarpTag.func_74768_a(NBT_TAG_WARP, 0);
            stack.func_77982_d(tWarpTag);
        }
        return tWarpLevel;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (!player.func_82150_aj()) {
            player.func_82142_c(true);
            ((EntityPlayer)player).field_71075_bZ.field_75102_a = true;
        }
        if (this.random.nextInt(20) > 0) {
            return;
        }
        NBTTagCompound forgeTag = this.getOrSetForgeTag((EntityPlayer)player);
        int corruption = 0;
        if (forgeTag.func_74764_b(NBT_TAG_MIND_CORRUPTION)) {
            corruption = forgeTag.func_74762_e(NBT_TAG_MIND_CORRUPTION);
        } else {
            forgeTag.func_74768_a(NBT_TAG_MIND_CORRUPTION, 0);
        }
        if (!player.field_70170_p.field_72995_K) {
            if (corruption == 0) {
                ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentText("\u00a75You have worn the Ring. Your soul has now been forever \u00a75tainted. \u00a74\u00a7oBeware of wearing the ring. The tainting will only \u00a74\u00a7oincrease, and strange things will start happening."));
            } else if (corruption > 300 && corruption < 1400 && this.random.nextInt(100) == 0) {
                ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentText("\u00a75The Ring somehow feels heavy"));
                if (this.random.nextBoolean()) {
                    player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 500, 2, false));
                } else {
                    player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 500, 2, false));
                }
            } else if (corruption >= 1400 && corruption < 3800 && this.random.nextInt(100) == 0) {
                ((EntityPlayer)player).field_71075_bZ.field_75102_a = false;
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 500, 2, false));
            } else if (corruption >= 3800 && corruption < 6500 && this.random.nextInt(100) == 0) {
                ((EntityPlayer)player).field_71075_bZ.field_75102_a = false;
                player.field_70181_x += 2.0;
            } else if (corruption >= 6500 && this.random.nextInt(10000) == 0) {
                ((EntityPlayer)player).field_71075_bZ.field_75102_a = false;
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100, 4, false));
            }
            if (corruption >= 300 && this.random.nextInt(100) == 0) {
                this.getItemWarpLevel(stack, true);
                ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentText("\u00a75The Ring suddenly starts to glow purple"));
            }
        }
        forgeTag.func_74768_a(NBT_TAG_MIND_CORRUPTION, ++corruption);
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        player.func_82142_c(false);
        if (!((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            ((EntityPlayer)player).field_71075_bZ.field_75102_a = false;
        }
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 1, false));
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return stack.func_77960_j() == 0 && player instanceof EntityPlayer;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        boolean tRet = false;
        if (this.random.nextInt(5) == 0) {
            tRet = true;
            ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentText("\u00a72You removed the Ring. Maybe you should think twice before using it next time?"));
        } else {
            ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentText("\u00a75Nooo, don't remove me! I give you great power!"));
        }
        return tRet;
    }

    public int getRunicCharge(ItemStack itemStack) {
        return 0;
    }
}

